//--------------------------------------------------------------------------
//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted 
//  by Texas Instruments is distributed as "freeware".  You may, 
//  only under TI's copyright in the Program, use and modify the 
//  Program without any charge or restriction.  You may 
//  distribute to third parties, provided that you transfer a 
//  copy of this license to the third party and the third party 
//  agrees to these terms by its first use of the Program. You 
//  must reproduce the copyright notice and any other legend of 
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains 
//  copyrighted material, trade secrets and other TI proprietary 
//  information and is protected by copyright laws, 
//  international copyright treaties, and trade secret laws, as 
//  well as other intellectual property laws.  To protect TI's 
//  rights in the Program, you agree not to decompile, reverse 
//  engineer, disassemble or otherwise translate any object code 
//  versions of the Program to a human-readable form.  You agree 
//  that in no event will you alter, remove or destroy any 
//  copyright notice included in the Program.  TI reserves all 
//  rights not specifically granted under this license. Except 
//  as specifically provided herein, nothing in this agreement 
//  shall be construed as conferring by implication, estoppel, 
//  or otherwise, upon you, any license or other right under any 
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.
//
//  File: emeter-setup.c
//
//  Steve Underwood <steve-underwood@ti.com>
//  Texas Instruments Hong Kong Ltd.
//
//  $Id: emeter-setup.c,v 1.30 2008/10/28 10:13:40 a0754793 Exp $
//
/*! \file emeter-structs.h */
//
//--------------------------------------------------------------------------
//
//  MSP430 setup routines for e-meters.
//
//  This software is appropriate for single phase and three phase e-meters
//  using a voltage sensor plus CT or shunt resistor current sensors, or
//  a combination of a CT plus a shunt. 
//
#include <stdint.h>
#include <string.h>

#include "io.h"
#include <emeter-toolkit.h>

#include "emeter-structs.h"


#include "..\display\Segment_LCD.h"
#include "..\display\LCD.h"
#include "..\display\Menu.h"
#ifdef USEDEVICEA
#define SD24CONF0_FUDGE     0x70
#define SD24CONF1_FUDGE     0x78    //for FE42xA
#else
#define SD24CONF0_FUDGE     0x70
#define SD24CONF1_FUDGE     0x48    //for FE42x
#endif
/*
* Analog front-end initialization routine.
*
* Configures the sigma-delta ADC module as analog front-end for
* a tamper-resistant meter using a current transformer and a
* shunt as current sensors (see configuration of channel 0 and 1).
*/
//static __inline__ void init_analog_front_end_normal(void)
void init_analog_front_end_normal(void)
{
    /*
    * Then the general configurations of the analog front-end are done
    * that apply to all channels: clock selection (SMCLK) and divider
    * settings (depending on SMCLK frequency) and reference voltage
    * selections.
    */
    /*
    * ǰͨãʱԴѡ񣬲οѹѡ
    */
    SD24CCTL_VOLTAGE &= ~SD24SC;
    SD24CCTL_LIVE &= ~SD24SC;
#if defined(NEUTRAL_MONITOR_SUPPORT)
    SD24CCTL_NEUTRAL &= ~SD24SC;
#endif
    
    SD24CTL = SD24SSEL_1  /* Clock is SMCLK */
        //            | SD24DIV_3   /* Divide by 8 => ADC clock: 1.048576MHz */
        | SD24REFON;  /* Use internal reference */
//    SD24CTL = 0;
    //SD24PRE_LIVE = 0;
    SD24PRE_LIVE = 128;
#if defined(NEUTRAL_MONITOR_SUPPORT)
    SD24PRE_NEUTRAL = 0;
#endif
    
    /* Configure analog front-end channel 2 - Voltage */
    SD24PRE_VOLTAGE = DEFAULT_VOLTAGE_PRELOAD; // λֵԤ,λʱ
    
    SD24INCTL0 = SD24INCH_0 | ((gSysconf&SYSCON_GAIN0_MASK)<<3);  /* Set gain for channel 0 (V) */  // 
    SD24INCTL1 = SD24INCH_0 | (gSysconf&SYSCON_GAIN1_MASK);    /* Set gain for channel 1 (I1) */    // ѹ
    SD24INCTL2 = SD24INCH_0 | ((gSysconf&SYSCON_GAIN2_MASK)>>3);   /* Set gain for channel 2 (I2) */  // 
    SD24CCTL0 = SD24OSR_256 | SD24DF | SD24GRP | SD24IE;     /* Set oversampling ratio to 256 (default) */
    SD24CCTL1 = SD24OSR_256 | SD24DF | SD24GRP | SD24IE;     /* Set oversampling ratio to 256 (default) */
    SD24CCTL2 = SD24OSR_256 | SD24DF | SD24SC | SD24IE;      /* Set oversampling ratio to 256 (default) */
    SD24PRE_KEY = 0x80;
#if defined(SD24CONF0_FUDGE)
    //SD24CONF0 = SD24CONF0_FUDGE;                /* Tweaks recommended by Freising */
#endif
#if defined(SD24CONF1_FUDGE)
    //SD24CONF1 = SD24CONF1_FUDGE;
#endif
    
    chan1.current[0].in_phase_correction[0].sd16_preloaded_offset = 0;
#if defined(NEUTRAL_MONITOR_SUPPORT)
    chan1.current[1].in_phase_correction[0].sd16_preloaded_offset = 0;
#endif
}

#if 1
void init_serial_port(void)
{
    ME1 |=  URXE0+UTXE0;                            // Enable USART0 RXD
    UCTL0 |= CHAR;                            // 8-bit character
    UTCTL0 |= SSEL1;                          // UCLK = SMCLK
//    UBR00 = 109;//0xB4;                             // 4.19MHz 9600
//    UBR10 = 0;//0x01;                             // 4.19MHz 9600
//    UMCTL0 = 0x03;                                 // modulation
    UBR00 = 0xB4;//0xB4;                             // 4.19MHz 9600
    UBR10 = 0x01;//0x01;                             // 4.19MHz 9600
    UMCTL0 = 0x7;                            // modulation  
    UCTL0 &= ~SWRST;                          // Initialize USART state machine
    IE1 |= URXIE0;                            // Enable USART0 RX interrupt    
#ifndef  TXISRUSED
    receiving = 1;
#endif
}
#else
void init_serial_port(void)
{}
#endif


void init_timer(void)
{
   // TACCR0 = 60;                           // 0.5s interrupt
    TACTL = TASSEL_2 + MC_2  + TACLR + TAIE;  // SMCLK, upmode, clear TAR  ,SMCLKѡʱѾ4Ƶ      
   // TACCTL1 = CCIE;                          // CCR0 interrupt enabled
    TACCR1 = 32768;
}

void init_rtc(void)
{
    rtc.year = 11;
    rtc.month = 5;
    rtc.day = 1;
    rtc.hour = 0;
    rtc.minute = 0;
    rtc.second = 0;
    rtc.sumcheck = ((~(rtc.second + rtc.minute + rtc.hour + rtc.day + rtc.month + rtc.year)) & 0xFF);
}

void init_menu(void)
{
    UpdataRTC1((unsigned char*)&rtc);              // ʱ
}

void switch_to_normal_mode(void)
{
    /* Switch to full speed, full power mode */
    _DINT();
    init_serial_port();
    init_analog_front_end_normal();
    init_timer();   //20110222
    init_rtc();
    Init_BU9796FS();
    init_menu();
    _EINT();
}

void system_setup(void)
{
    kick_watchdog();    /* Set the watchdog timer to exactly 1s */
    
    /* IOʼ --> SVS IICӲUART,UART壬*/
#if defined(P1OUT_INIT)
    P1OUT = P1OUT_INIT;
#endif
#if defined(P1DIR_INIT)
    P1DIR = P1DIR_INIT;
#endif
#if defined(P1SEL_INIT)
    P1SEL = P1SEL_INIT;
#endif
    /*
    P1DIR |= BIT0;//SMCLK    
    P1SEL |= BIT0;//SMCLK    
    P1SEL2 |= BIT0;//SMCLK
    */
    P1SEL2 = 0; // 20110211 RAY
    
#if defined(P2OUT_INIT)
    P2OUT = P2OUT_INIT;
#endif
#if defined(P2DIR_INIT)
    P2DIR = P2DIR_INIT;
#endif
#if defined(P2SEL_INIT)
    P2SEL = P2SEL_INIT;
#endif	
    P2SEL2 = 0;
/*
    //config SPI to 3 wire or 4 wire mode according to SPI_STE_BIT status
    //SPI_STE_BIT connect to 0            3 wire  
    //SPI_STE_BIT hold 1 by Host          4 wire
    //So in a 3 wire SPI case, user need to tie SPI_STE_BIT to GND
    delay(2000);//1ms
    uint8_t i, cnt = 0;
    for( i = 0; i < 100; i++){
        if(SPI_STE_IN&SPI_STE_BIT)
            cnt++;
        else
            if(cnt!=0)
                cnt--;
    }
    if(cnt > 10)		
        meter_status |= SPI4W;    
with no spi,  by ray 20110211*/     
    /* Prime the DC estimates for quick settling */
    phase->current[0].I_dc_estimate[0] = phase_nv->initial_I_dc_estimate[0];   // dcƫԤֵںУл
    phase->current[0].I_endstops = ENDSTOP_HITS_FOR_OVERLOAD;                  // شʼֵ
#if defined(NEUTRAL_MONITOR_SUPPORT)
    phase->current[1].I_dc_estimate[0] = phase_nv->initial_I_dc_estimate[1];   // ͬϣΪnectral
    phase->current[1].I_endstops = ENDSTOP_HITS_FOR_OVERLOAD;
#endif
    phase->V_dc_estimate = phase_nv->initial_v_dc_estimate;           // ѹdcƫԤֵ
    phase->V_endstops = ENDSTOP_HITS_FOR_OVERLOAD;
#if defined(MAINS_FREQUENCY_SUPPORT)                                  // ڣƵʣ
    phase->mains_period = ((SAMPLES_PER_10_SECONDS*6554)/MAINS_NOMINAL_FREQUENCY) << 8;
#endif
    
    phase->V_accum = 0;
    phase->V_accum_logged = 0;
    phase->I_accum[0] = 0;
    phase->I_accum_logged[0] = 0;
    phase->I_accum[1] = 0;    
    phase->I_accum_logged[0] = 0;
    //phase->V_dc = phase_nv->initial_v_dc_estimate;
    //phase->I_dc[0] = phase_nv->initial_I_dc_estimate[0];
    //phase->I_dc[1] = phase_nv->initial_I_dc_estimate[1];
    
#if defined(__MSP430_HAS_SVS__)
    /* Before we go to high speed we need to make sure the supply voltage is 
    adequate. If there is an SVS we can use that. There should be no wait
    at this point, since we should only have been woken up if the supply
    is healthy. However, it seems better to be cautious. */
    //    SVSCTL |= (SVSON | 0x60);
    /*
    SVSCTL = (SVSON | 0xa0);  //0xb0 3.2v, 0xa0 3.05v, 0x90 2.9V
    BY RAY 20110211*/
    SVSCTL = (SVSON | 0xF0);  //ⲿͨ
    /* Wait for adequate voltage to run at full speed */
//    while ((SVSCTL & SVSOP));
    menustatu.poweroff_fg = 0;
        /* dummy loop */;
    /* The voltage should now be OK to run the CPU at full speed. Now it should
    be OK to use the SVS as a reset source. */
#endif
    
    DCOCTL = 0x7d;    //16MHz                      
    BCSCTL1 = 0x8f;   //16MHz
    //    DCOCTL = 0x6f;    //8MHz                      
    //    BCSCTL1 = 0x8d;   //8MHz
    BCSCTL1 &= ~(XT2OFF);       //switch on XT2
    do
    {
        IFG1 &= ~OFIFG;                       // ʧЧ־
        BCSCTL3 &= ~XT2OF;                    // XT2ʧЧ־
        for( unsigned int i = 0x47FF; i > 0; i-- );   // ȴXT2Ƶȶ
    }while (IFG1 & OFIFG);                    // ⲿʱԴ    
    BCSCTL2 |= SELS | DIVS_2;   //SMCLK select XT2, div 4                 
    BCSCTL3 = XT2S_2 | LFXT1S_2;   //4~16MHz, VLO for ACLK    
    FCTL2 = FWKEY | FSSEL0 | FN4 | FN2;             // MCLK/21 = 400kHz Ϊʲôѡ400K...
    
    kick_watchdog();
    switch_to_normal_mode();
}

/*
gChecksum1 += phase_nv->current[0].Ac_offset;
gChecksum1 += phase_nv->current[1].Ac_offset;
gChecksum1 += phase_nv->current[0].I_rms_scale_factor[0];
gChecksum1 += phase_nv->current[1].I_rms_scale_factor[0];
gChecksum1 += phase_nv->current[0].P_scale_factor[0];
gChecksum1 += phase_nv->current[1].P_scale_factor[0];
gChecksum1 += phase_nv->current[0].Phase_correction[0];
gChecksum1 += phase_nv->current[1].Phase_correction[0];
gChecksum1 += phase_nv->current[0].Offset_active_power;
gChecksum1 += phase_nv->current[1].Offset_active_power;
gChecksum1 += phase_nv->current[0].Offset_reactive_power;
gChecksum1 += phase_nv->current[1].Offset_reactive_power;
gChecksum1 += phase_nv->V_rms_scale_factor;
*/
#define OFFSET_ENDOF_CAL_DATA 13 //13 words
void Checksum1_update()
{  
    uint8_t i;
    uint16_t * p = (uint16_t *)phase_nv;
    
    gChecksum1 = 0;
    for(i = 0; i < OFFSET_ENDOF_CAL_DATA; i++){
        gChecksum1 += *p;
        p++;
    }
}


#define OFFSET_ENDOF_METER_READING 18 //18 words
/*
gChecksum2 += phase->active_power[0];
gChecksum2 += phase->active_power[0] >> 16;
gChecksum2 += phase->active_power[1];
gChecksum2 += phase->active_power[1] >> 16;
gChecksum2 += phase->reactive_power[0];
gChecksum2 += phase->reactive_power[0] >> 16;
gChecksum2 += phase->reactive_power[1];
gChecksum2 += phase->reactive_power[1] >> 16;
gChecksum2 += phase->apparent_power[0];
gChecksum2 += phase->apparent_power[0] >> 16;
gChecksum2 += phase->apparent_power[1];
gChecksum2 += phase->apparent_power[1] >> 16;
gChecksum2 += phase->V_rms;
gChecksum2 += phase->frequency;
gChecksum2 += phase->I_rms[0];
gChecksum2 += phase->I_rms[1];
gChecksum2 += phase->power_factor[0];
gChecksum2 += phase->power_factor[1];

void Checksum2_update()
{
uint8_t i;
uint16_t * p = (uint16_t *)phase;

gChecksum2 = 0;
for(i = 0; i < OFFSET_ENDOF_METER_READING; i++){
gChecksum2 += *p;
p++;
  }
}
*/
void data_init(void)
{
    /*! \system configuration */    
    gSysconf = DEFAULT_SYSCONF;   // default:· shunt
    /*! \AFE functions configuration */    
    gCsgconf = DEFAULT_AFECONF;   // large current and |p|
    /*! \power constant for pulse*/    
    gPower_const = DEFAULT_POWERCONST;  // Ĭ峣 1600
    /*! \start current */    
    gStart_curr = DEFAULT_STARTCURRENT; //  220 ... Сڴ˵
    /*! \csg local status */      
    meter_status = 0;                   // Meter status flag bits
    /* check sum for calibrations data */
    Checksum1_update();
}

void csg_config(void)
{
    unsigned char shiftbit = 0;
    gCurrent_threshold = TOTAL_ENERGY_PULSE_THRESHOLD;
    
    if(gPower_const > 0){       //make sure power const is not 0 or negtive to avoid divide 0 error, or else set power const to 1600
        if(gPower_const > 1000)  //in normal power counter mode, multiply 16 times to compensate the shiftright while defination of TOTAL_ENERGY_PULSE_THRESHOLD
            gCurrent_threshold = gCurrent_threshold*16;
        gCurrent_threshold = gCurrent_threshold/gPower_const;
        gCurrent_threshold = gCurrent_threshold*1600;
    }
    
    if((gCsgconf&CSGCON_FPEN)==CSGCON_FPEN){  //fast pulse mode enabled, adjust threshold with fast pulse factor
        shiftbit = (gCsgconf&CSGCON_FPFACTOR_MASK)>>2;
        gCurrent_threshold = gCurrent_threshold>>shiftbit;
    }
    
    if((gCsgconf&CSGCON_CSEL_MASK)==CSGCON_CSEL2)//channel B mode                      
        phase->status |= CURRENT_FROM_NEUTRAL;
    if((gCsgconf&CSGCON_CSEL_MASK)==CSGCON_CSEL1)//channel A mode                      
        phase->status &= ~CURRENT_FROM_NEUTRAL;
    //gCsgconf |= CSGCON_IDFILTERTYPE;
    //initate interrupt mask only with new log interrupt 
    // 
   // phase->int_enable |= CSGENRDYFG;  // CSG energy ready  ȡ׼
}
